


library(MASS)

mediateo=5
sigmateo=2

dati <- rnorm(1000, mediateo, sigmateo)
datifit <- fitdistr(dati, "normal")

mediafit <- coef(datifit)[1]
sigmafit <- coef(datifit)[2]


par(mfrow=c(1,2))

hist(dati, freq = TRUE, nclass = 20)
hist(dati, freq = FALSE, nclass = 20)

counts = hist(dati, freq = FALSE, nclass = 20)$counts
freq = hist(dati, freq = FALSE, nclass = 20)$density

sum(counts)
sum(freq)

breaks = hist(dati, freq = FALSE, nclass = 20)$breaks

DeltaX = breaks[2] - breaks[1]

sum(freq)*DeltaX




########### calcoliamo il chi2

classi = 20
minimo = -2
massimo = 12


intervalli = 0

for (k in 1:(classi+1)) {
    intervalli[k] = minimo + (k-1)*((massimo-minimo)/classi)
}


####### frequenze osservate

O = 0
O <- (hist(dati, breaks = intervalli)$counts)

sum(O)


estremi = 0
estremi <- hist(dati, breaks = intervalli)$breaks


Enorm = 0
for (i in 1:(length(estremi)-1)) {
    Enorm[i] = pnorm(estremi[i+1], mediafit, sigmafit, lower.tail = T) -
    pnorm(estremi[i], mediafit, sigmafit, lower.tail = T)
}

E=Enorm*sum(O)

ndof = length(O)-2

chi2man = sum(((O-E)^2)/E)
chi2manRid = chi2man/ndof


chi2manRid









classi <- seq(from = 2, to = 100, by = 2)

minimo = -2
massimo = 12

chi2scan = 0

numero = 0




intervalli = 0

for (k in 1:(classi[j]+1)) {
  intervalli[k] = minimo+(k-1)*((massimo-minimo)/classi[j])
}
O = 0
O <- hist(dati, breaks = intervalli)$counts


estremi = 0
estremi <- hist(dati, breaks = intervalli)$breaks
numero[j] = length(O)

Enorm = 0
 for (i in 1:(length(estremi)-1)) {
      Enorm[i] = pnorm(estremi[i+1], mediafit, sigmafit, lower.tail = T) -
      pnorm(estremi[i], mediafit, sigmafit, lower.tail = T)
      }
 E=Enorm*sum(O)
ndof = length(O)-2

chi2man = sum(((O-E)^2)/E)
 chi2manRid = chi2man/ndof

#pchisq(chi2man, ndof, lower.tail = F)
#chisq.test(O, p = E, rescale.p = T)

xclass = 0
for (i in 1:(length(estremi)-1)) {
    xclass[i] = (estremi[i+1]+estremi[i])/2
}

chi2scan[j] = chi2manRid

}

plot(classi, chi2scan, type = "l")


par(mfrow=c(3,1))

hist(dati, nclass = 8)
curve((sum(O)/(sigmafit*sqrt(2*3.14)))*exp(((x-mediafit)^2)/(-2*(sigmafit^2))), from = -5, to = 15, add = T, col = 2, lwd = 4)

hist(dati, ylim = c(0,200), nclass = 16)
curve((sum(O)/(sigmafit*sqrt(2*3.14)))*exp(((x-mediafit)^2)/(-2*(sigmafit^2))), from = -5, to = 15, add = T, col = 2, lwd = 4)

hist(dati, ylim = c(0,200), nclass = 32)
curve((sum(O)/(sigmafit*sqrt(2*3.14)))*exp(((x-mediafit)^2)/(-2*(sigmafit^2))), from = -5, to = 15, add = T, col = 2, lwd = 4)
